% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarCollection.R
\name{get_risk_group_names,familiarCollection-method}
\alias{get_risk_group_names,familiarCollection-method}
\alias{get_risk_group_names}
\title{Get current risk group labels}
\usage{
\S4method{get_risk_group_names}{familiarCollection}(x)
}
\arguments{
\item{x}{A familiarCollection object.}
}
\value{
An ordered array of risk group labels.
}
\description{
Risk groups in familiarCollection objects can have custom names
for export and plotting. This function retrieves the currently assigned
names.
}
\details{
Labels convert internal naming of risk groups to the requested label
at export or when plotting. Labels can be changed using the
\code{set_risk_group_names} method.
}
\seealso{
\itemize{
\item \linkS4class{familiarCollection} for information concerning the familiarCollection class.
\item \code{\link{set_risk_group_names}} for updating the name and ordering of risk groups.
}
}
