% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastOnlineCpt.r
\name{fastOnlineCpt}
\alias{fastOnlineCpt}
\title{Initialize a new object of the class "fastOnlineCpt". This object allows one to add data in an online fashion and test for a changepoint.}
\usage{
fastOnlineCpt(spending_sequence)
}
\arguments{
\item{spending_sequence}{A function \eqn{f(n)} of one argument which for every \eqn{n} returns a testing threshold such that \eqn{\sum_{n=1}^\infty f(n) = \alpha}, where \eqn{\alpha} is the desired level of the test over the (possibly infinite) time horizon.}
}
\value{
A new object of the class "fastOnlineCpt".
}
\description{
Initialize a new object of the class "fastOnlineCpt". This object allows one to add data in an online fashion and test for a changepoint.
}
\examples{
library(fastOnlineCpt)
alpha <- 0.01
halfspent <- 100
spending_sequence <- function(n) { (n/(n+halfspent) - (n-1)/(n-1+halfspent)) * alpha }
obj <- fastOnlineCpt(spending_sequence)

}
\references{
Hahn, G. (2021). Online multivariate changepoint detection with type I error control and constant time/memory updates per series. Under review.
}
