% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.rewired.caveman.R
\name{net.rewired.caveman}
\alias{net.rewired.caveman}
\title{Rewired (Connected) Caveman Network}
\usage{
net.rewired.caveman(nc, m, p, seed = 99)
}
\arguments{
\item{nc}{Number of cliques (or caves) in the network.}

\item{m}{Number of nodes per clique.}

\item{p}{Link rewiring probability.}

\item{seed}{A random seed.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a rewired caveman network of m cliques of size k, and with a link rewiring probability p.
}
\details{
The rewired caveman network is built on the corresponding regular caveman network with m cliques of size k. Then the links in this caveman network are rewired with probability p.
}
\examples{
\dontrun{
x <- net.rewired.caveman(50, 20, 0.0005)}
}
\references{
Watts, D. J. Networks, Dynamics, and the Small-World Phenomenon. Amer. J. Soc. 105, 493-527, 1999.
}
\author{
Xu Dong, Nazrul Shaikh
}
