% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_friedman.R
\name{gen_friedman}
\alias{gen_friedman}
\title{Friedman benchmark data}
\usage{
gen_friedman(
  n_samples = 100,
  n_features = 10,
  n_bins = NULL,
  sigma = 0.1,
  seed = NULL
)
}
\arguments{
\item{n_samples}{Integer specifying the number of samples (i.e., rows) to
generate. Default is 100.}

\item{n_features}{Integer specifying the number of features to generate.
Default is 10.}

\item{n_bins}{Integer specifying the number of (roughly) equal sized bins to
split the response into. Default is \code{NULL} for no binning. Setting to
a positive integer > 1 effectively turns this into a classification problem
where \code{n_bins} gives the number of classes.}

\item{sigma}{Numeric specifying the standard deviation of the noise.}

\item{seed}{Integer specifying the random seed. If \code{NULL} (the default)
the results will be different each time the function is run.}
}
\description{
Simulate data from the Friedman 1 benchmark problem. These data were
originally described in Friedman (1991) and Breiman (1996). For details, see
\href{https://scikit-learn.org/stable/modules/generated/sklearn.datasets.make_friedman1.html}{sklearn.datasets.make_friedman1}.
}
\note{
This function is mostly used for internal testing.
}
\examples{
gen_friedman()
}
\references{
Breiman, Leo (1996) Bagging predictors. Machine Learning 24, pages 123-140.

Friedman, Jerome H. (1991) Multivariate adaptive regression splines. The
Annals of Statistics 19 (1), pages 1-67.
}
