% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abort_if_not.r
\name{abort_if_not}
\alias{abort_if_not}
\alias{abort_if}
\title{Ensure the truth of R expressions}
\usage{
abort_if_not(..., .message = NULL, .error_call = caller_env())

abort_if(..., .message = NULL, .error_call = caller_env())
}
\arguments{
\item{...}{any number of R expressions, which should each evaluate to
(a logical vector of \link{all}) \code{TRUE} for no error to occur. Positive numbers
are not \code{TRUE}, even when they are coerced to \code{TRUE} inside \verb{if()} or in
arithmetic computations in R. If the expressions are named, the names
will be used in the error message.}

\item{.message}{single default error message for non-named expressions.}

\item{.error_call}{the call environment to use for error messages
(passed to \link[rlang:abort]{abort}).}
}
\value{
NULL, called for side effects only.
}
\description{
If any of the expressions in \code{...} are not all \code{TRUE}, \link[rlang:abort]{abort} is
called for the first expression which was not (\link{all}) \code{TRUE}. The names
of expressions can be used as the error message or a single default error
message can be given using \code{.message}. Both are passed to
\link[cli:format_inline]{format_inline} for formatting.
}
\details{
\link{abort_if} is the opposite of \link{abort_if_not},
i.e. expressions should evaluate to (\link{all}) \code{FALSE} for no error to
occur. See \link{enforce} and \link{schema} for a non data-masked
and data-masked version of \link{abort_if_not} with options for size
recycling and type casting.
}
\examples{
# NB: Some of these examples are expected to produce an error. To
#     prevent them from terminating a run with example() they are
#     piped into a call to try().

abort_if_not(1 == 1, all.equal(pi, 3.14159265), 1 < 2) # all TRUE

m <- matrix(c(1, 3, 3, 1), 2, 2)
abort_if_not(m == t(m), diag(m) == rep(1, 2)) # all TRUE

abort_if_not(1) |> try()

# A custom error message can be given for each expression:
m[1, 2] <- 12
abort_if_not("{.var m} must be {.cls symmetric}" = m == t(m)) |>
  try()

# Alternatively, one error message can be used for all
# expressions:
abort_if_not(
  m[1, 1] == 1,
  diag(m) == rep(2, 2),
  .message = "{.var m} has a diagonal of: {diag(m)}"
) |> try()

# The `.error_call` argument can be used to specify where the
# error occurs, by default this is the caller environment:
myfunc <- function(x) abort_if_not(x)
myfunc(FALSE) |> try()

# abort_if() errors if any argument does not evaluate to
# (all) FALSE:
abort_if(1 == 1) |> try()

# Injection can be used:
x <- "my error"
abort_if_not({{ x }} := FALSE) |> try()
abort_if_not(!!x := FALSE) |> try()
abort_if_not(FALSE, .message = "{x}") |> try()

x <- list("my {.var bang-bang-bang} error" = FALSE)
abort_if_not(!!!x) |> try()
}
