% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_contexts.R
\name{RandomContext}
\alias{RandomContext}
\title{Generate Random Formal Contexts}
\usage{
RandomContext(
  n_objects,
  n_attributes,
  density = 0.1,
  distribution = "uniform",
  alpha = 1,
  ...
)
}
\arguments{
\item{n_objects}{(integer) Number of objects.}

\item{n_attributes}{(integer) Number of attributes.}

\item{density}{(numeric) Expected density of the context (proportion of 1s). Used for uniform distribution.}

\item{distribution}{(character) The distribution to use for generating the context.
\itemize{
\item \code{"uniform"}: Each cell is 1 with probability \code{density}.
\item \code{"dirichlet"}: The number of attributes per object follows a categorical distribution
derived from a Dirichlet distribution. This creates "clumpy" or "sparse" rows typical of real data.
}}

\item{alpha}{(numeric) Concentration parameter for the Dirichlet distribution.
Low values (e.g., 0.1) produce very skewed distributions (some objects have few attributes, others many).
High values produce more uniform row sums. Default is 1.0.}

\item{...}{Additional arguments passed to internal methods.}
}
\value{
A \code{FormalContext} object.
}
\description{
Functions to generate synthetic formal contexts using advanced statistical distributions.
These methods allow creating datasets that mimic real-world properties (non-uniform density)
or randomizing existing contexts while preserving their structural properties.
}
\examples{
# 1. Uniform Random Context
fc_uni <- RandomContext(10, 5, density = 0.2)
print(fc_uni)

# 2. Dirichlet Random Context (Mimicking real data structure)
# Objects will have varying 'sizes' (number of attributes)
fc_dir <- RandomContext(10, 5, distribution = "dirichlet", alpha = 0.5)
print(fc_dir)

}
