% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{ft_count}
\alias{ft_count}
\title{Reorder Factor Levels by Level Count}
\usage{
ft_count(factor_vec, decreasing = TRUE, inplace = FALSE)
}
\arguments{
\item{factor_vec}{A factor vector whose levels are to be reordered.}

\item{decreasing}{Logical. Should the ordering be decreasing by count? Default is \code{TRUE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with only the levels' order adjusted, leaving the data vector's elements' order unchanged. Defaults to \code{FALSE}.}
}
\value{
A factor vector with levels reordered based on their count.
}
\description{
Reorders the levels of a factor vector based on the count of each level in the data.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'apple', 'cherry', 'banana', 'banana', 'date'))

# Reorder levels by decreasing count
ft_count(factor_vec)

# Reorder levels by increasing count
ft_count(factor_vec, decreasing = FALSE)
}
\author{
Kai Guo
}
