% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestFunctions.R
\name{fEqDistrib.test}
\alias{fEqDistrib.test}
\alias{XYRP.test}
\alias{MMD.test}
\alias{MMDA.test}
\title{Tests for checking the equality of distributions between two functional populations.}
\usage{
XYRP.test(X.fdata, Y.fdata, nproj = 10, npc = 5, test = c("KS", "AD"))

MMD.test(
  X.fdata,
  Y.fdata,
  metric = "metric.lp",
  B = 1000,
  alpha = 0.95,
  kern = "RBF",
  ops.metric = list(lp = 2),
  draw = FALSE
)

MMDA.test(
  X.fdata,
  Y.fdata,
  metric = "metric.lp",
  B = 1000,
  alpha = 0.95,
  kern = "RBF",
  ops.metric = list(lp = 2),
  draw = FALSE
)

fEqDistrib.test(
  X.fdata,
  Y.fdata,
  metric = "metric.lp",
  method = c("Exch", "WildB"),
  B = 5000,
  ops.metric = list(lp = 2),
  iboot = FALSE
)
}
\arguments{
\item{X.fdata}{\code{fdata} object containing the curves from the first population.}

\item{Y.fdata}{\code{fdata} object containing the curves from the second population.}

\item{nproj}{Number of projections for \code{XYRP.test}.}

\item{npc}{The number of principal components employed for generating the random projections.}

\item{test}{For \code{XYRP.test} "KS" and/or "AD" for computing Kolmogorov-Smirnov or Anderson-Darling p-values in the projections.}

\item{metric}{Character with the metric function for computing distances among curves.}

\item{B}{Number of bootstrap or Monte Carlo replicas.}

\item{alpha}{Confidence level for computing the threshold. By default =0.95.}

\item{kern}{For \code{MMDA.test} "RBF" or "metric" for indicating the use of Radial Basis Function or directly, the distances.}

\item{ops.metric}{List of parameters to be used with \code{metric}.}

\item{draw}{By default, FALSE. Plots the density of the bootstrap replicas jointly with the statistic.}

\item{method}{In \code{fEqDistrib.test} a character indicating the bootstrap method for computing the distribution under H0.
"Exch" for Exchangeable bootstrap and "WildB" for Wild Bootstrap. By default, both are provided.}

\item{iboot}{In \code{fEqDistrib.test} returns the bootstrap replicas.}
}
\value{
A list with the following components by function:
\itemize{
\item \code{XYRP.test}, \code{FDR.pv}: p-value using FDR, \code{proj.pv}: Matrix of p-values obtained for projections.
\item \code{MMD.test}, \code{MMDA.test}: \code{stat}: Statistic, \code{p.value}: p-value, \code{thresh}: Threshold at level \code{alpha}.
\item \code{fEqDistrib.test}, \code{result}: \code{data.frame} with columns \code{Stat} and \code{p.value}, 
\code{Boot}: \code{data.frame} with bootstrap replicas if \code{iboot=TRUE}.
}
}
\description{
Three tests for the equality of distributions of two populations are provided. The null hypothesis is that the two populations are the same
}
\details{
\code{\link{XYRP.test}} computes the p-values using random projections. Requires \code{kSamples} library. 
\code{\link{MMD.test}} computes Maximum Mean Discrepancy p-values using permutations (see Sejdinovic et al, (2013)) and \code{\link{MMDA.test}} 
does the same using an asymptotic approximation. 
\code{\link{fEqDistrib.test}} checks the equality of distributions using an embedding in a RKHS and two bootstrap approximations for 
calibration.
}
\examples{
\dontrun{
tt=seq(0,1,len=51)
bet=0
mu1=fdata(10*tt*(1-tt)^(1+bet),tt)
mu2=fdata(10*tt^(1+bet)*(1-tt),tt) 
fsig=1
X=rproc2fdata(100,tt,mu1,sigma="vexponential",par.list=list(scale=0.2,theta=0.35))
Y=rproc2fdata(100,tt,mu2,sigma="vexponential",par.list=list(scale=0.2*fsig,theta=0.35))
fmean.test.fdata(X,Y,npc=-.98,draw=TRUE)
cov.test.fdata(X,Y,npc=5,draw=TRUE)
bet=0.1
mu1=fdata(10*tt*(1-tt)^(1+bet),tt)
mu2=fdata(10*tt^(1+bet)*(1-tt),tt) 
fsig=1.5
X=rproc2fdata(100,tt,mu1,sigma="vexponential",par.list=list(scale=0.2,theta=0.35))
Y=rproc2fdata(100,tt,mu2,sigma="vexponential",par.list=list(scale=0.2*fsig,theta=0.35))
fmean.test.fdata(X,Y,npc=-.98,draw=TRUE)
cov.test.fdata(X,Y,npc=5,draw=TRUE)
XYRP.test(X,Y,nproj=15)
MMD.test(X,Y,B=1000)
fEqDistrib.test(X,Y,B=1000)
}

}
\references{
Sejdinovic, D., Sriperumbudur, B., Gretton, A., Fukumizu, K. \emph{Equivalence of distance-based and RKHS-based statistics in Hypothesis Testing} The Annals of Statistics, 2013. 
DOI \bold{10.1214/13-AOS1140}.
}
\seealso{
\code{\link{fmean.test.fdata}, \link{cov.test.fdata}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.febrero@usc.es}
}
\keyword{htest}
