% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata2basis.R
\name{fdata2basis}
\alias{fdata2basis}
\alias{summary.basis.fdata}
\title{Compute fucntional coefficients from functional data represented in a base of functions}
\usage{
fdata2basis(fdataobj, basis, method = c("grid", "inprod"))

\method{summary}{basis.fdata}(object, draw = TRUE, index = NULL, ...)
}
\arguments{
\item{fdataobj}{\code{\link{fdata}} class object.}

\item{basis}{a functional basis object defining the basis}

\item{method}{character string, if it is "grid" the fdata object is evaluated in the grid (\code{argvals} of fdata),
if it is "inprod" the basis representation of functional data is computed by inner product 
(\code{\link{inprod.fdata}(fdataobj,basis)}).}

\item{object}{\code{basis.fdata} class object calculated by: \code{\link{fdata2basis}}}

\item{draw}{logical, original curves  and their basis representation are plotted}

\item{index}{vector, by default (if NULL) the first n curves are plotted, where n = min(4, length(fdataobj)). 
Otherwise, index vector indicates taht curvesare plotted.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
The \code{fdata2basis} function returns: 
\itemize{
\item \code{coef}:  A matrix or two-dimensional array of coefficients.
\item \code{basis}:  Basis of \code{\link{fdata}} class evaluated on the same grid as \code{fdataobj}. 
}
And  summary function return: 
\itemize{
\item \code{R}: a matrix with a measure similar to R-sq for each curve aproximation (by row) and number of basis elements (by column).
}
}
\description{
Compute fucntional coefficients from functional data (\code{\link{fdata}} class object) 
represented in a basis (fixed of data-driven basis).
}
\examples{
\dontrun{
T <- 71
S <- 51
tj <- round(seq(0,1,len=T),3)
si <- round(seq(0,1,len=S),3)
beta1 <- outer(si,tj,function(si,tj){exp(-5*abs((tj-si)/5))})
nbasis.s =7
nbasis.t=11
base.s <- create.fourier.basis(c(0,1),nbasis=nbasis.s)
base.t <- create.fourier.basis(c(0,1),nbasis=nbasis.t)
y1 <- fdata(rbind(log(1+tj),1-5*(tj-0.5)^2),argvals=tj,rangeval=c(0,1))
aa <- fdata2basis(y1,base.t,method="inprod")
summary(aa)
plot(gridfdata(aa$coefs,aa$basis))
lines(y1,lwd=2,col=c(3,4),lty=2)
}
}
\seealso{
Inverse function: \code{\link{gridfdata}}.
Alternative method: \code{\link{fdata2pc}}, \code{\link{fdata2pls}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente  \email{manuel.oviedo@usc.es}
}
\keyword{multivariate}
