% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-sffa-assessment.R
\name{plot_sffa_assessment}
\alias{plot_sffa_assessment}
\title{Plot Model Assessment for S-FFA}
\usage{
plot_sffa_assessment(results, ...)
}
\arguments{
\item{results}{List; model assessment results generated by \code{\link[=model_assessment]{model_assessment()}}.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; a plot containing:
\itemize{
\item A black line representing a model with no deviation from the empirical quantiles.
\item Red points denoting the estimated quantiles against the empirical quantiles.
}
}
\description{
Creates a quantile–quantile plot comparing observed annual maximum series
data to quantile estimates from a fitted parametric model. The 1:1 line is drawn in
black and the parametric model estimates are plotted as semi‐transparent red points.
}
\examples{
# Initialize example data
data <- rnorm(n = 100, mean = 100, sd = 10)

# Evaluate model diagnostics
results <- model_assessment(data, "NOR", "L-moments")

# Generate a model assessment plot
plot_sffa_assessment(results)

}
