% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c2df.R, R/c2m.R, R/m2c.R
\name{c2df}
\alias{c2df}
\alias{c2m}
\alias{m2c}
\title{Conversion between matrices and partitioned matrices}
\usage{
c2df(CC)

c2m(CC)

m2c(M, df = rep(1, dim(M)[2]))
}
\arguments{
\item{CC}{list of matrices, typically the output of \code{m2c}}

\item{M}{matrix to be partitioned according to \code{df}}

\item{df}{integer vector.  See Details}
}
\value{
\code{m2c} returns a list of matrices.

\code{c2m} returns a matrix.

\code{c2df} returns a numeric vector.
}
\description{
Functions to convert a matrix to a list of partitioned matrices, and back
again.
}
\details{
\code{m2c} partitions a matrix into a list of matrices, by putting the first
\code{df[1]} coloumns into the first matrix, the next \code{df[2]} coloumns
into the second, etc.

\code{c2m} joins a partitioned matrix back into a single matrix.
\code{c2m(m2c(X, df))} equals \code{X}.

\code{c2df} takes a list of matrices and returns a vector with the number of
coloumns of the matrices.
}
\note{
\code{sum(df)} must equal \code{ncol(X)}.
}
\seealso{
\code{\link{ffmanova}}
}
\author{
Øyvind Langsrud and Bjørn-Helge Mevik
}
\keyword{internal}
\keyword{utilities}
