% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_filters.R
\name{load_filters}
\alias{load_filters}
\title{Load Filter Definitions}
\usage{
load_filters(yaml_file, overwrite = FALSE)
}
\arguments{
\item{yaml_file}{\code{character}. A path to a yaml file containing filter definitions}

\item{overwrite}{\code{logical}. Should existing filter definitions be overwritten?
Defaults to \code{FALSE}.}
}
\value{
On success, \code{load_filters()} returns \code{TRUE} invisibly
}
\description{
Load filter definitions from a yaml file
}
\examples{
filter_definitions <- system.file("filters.yaml", package = "filters")
if (interactive()) file.edit(filter_definitions)
load_filters(filter_definitions, overwrite = TRUE)

}
\author{
Thomas Neitmann (\code{neitmant})
}
