% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{mfrr_em_price_regulation_down}
\alias{mfrr_em_price_regulation_down}
\title{Down-regulation price in the Balancing energy market}
\usage{
mfrr_em_price_regulation_down(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type EUR/MWh.
}
\description{
Down-regulation price in the Balancing energy market. The price of the cheapest regulating bid used in the balancing power market during the particular hour; however, at the most the price for price area Finland in Nord Pool Spot (Elspot FIN).Down-regulating price in Finland is the price of the most expensive down-regulating bid used in the Balancing energy market during the hour in question; however, it is at the most the day ahead market price for the price area Finland. Down-regulating price for each hour is published hourly with one hour delay, eg. information from hour 07-08 is published at 9 o'clock.Balancing energy market is market place for manual freqeuency restoration reserve (mFRR) which is used to balance the electricity generation and consumption in real time. The Balancing energy market organized by Fingrid is part of the Nordic Balancing energy market that is called also Regulating power market. Fingrid orders up- or down-regulation from the Balancing energy market. Down-regulation considers increasing of consumption or reducing of generation.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- mfrr_em_price_regulation_down(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/106
}
