% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{get.genocol}
\alias{get.genocol}
\title{Generate a set of genotype (dosage) colors for XY-plots}
\usage{
get.genocol(ploidy, pastel=TRUE)
}
\arguments{
\item{ploidy}{any ploidy level >= 2}

\item{pastel}{if TRUE (default) light (pastel) colors are generated, else more
intense colors}
}
\value{
A vector of <ploidy + 2> color values; items 1 .. ploidy+1 for
dosage 0 .. ploidy and item ploidy+2 for missing dosages
}
\description{
For each of the dosages 0 to ploidy a color is generated,
and an additional one for samples with no dosage assigned.
}
\details{
the colors range from red (first item, dosage 0) via blue
(dosage ploidy/2) to green (dosage ploidy); the color for missing dosage is
grey
}
