% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleep.R
\name{get_sleep_stage_summary}
\alias{get_sleep_stage_summary}
\title{Nightly Sleep Stage Summary Data}
\usage{
get_sleep_stage_summary(start_date, end_date = start_date)
}
\arguments{
\item{start_date}{The start date of records to be returned in "yyyy-mm-dd" or date(time) format}

\item{end_date}{The end date of records to be returned in "yyyy-mm-dd" or date(time) format}
}
\value{
A tibble of a variety of sleep stage summary data, by day
}
\description{
Returns a tibble of nightly sleep stage data.
Minutes in each stage, count of times in each stage, and a thirty day average for the number of minutes in each stage.
}
\examples{
\dontrun{
start_date <- lubridate::today() - lubridate::weeks(1)
end_date <- lubridate::today()

get_sleep_stage_summary(start_date, end_date)
}

}
