% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{candy_rankings}
\alias{candy_rankings}
\title{Candy Power Ranking}
\format{
A data frame with 85 rows representing Halloween candy and 13 variables:
\describe{
  \item{competitorname}{The name of the Halloween candy.}
  \item{chocolate}{Does it contain chocolate?}
  \item{fruity}{Is it fruit flavored?}
  \item{caramel}{Is there caramel in the candy?}
  \item{peanutyalmondy}{Does it contain peanuts, peanut butter or almonds?}
  \item{nougat}{Does it contain nougat?}
  \item{crispedricewafer}{Does it contain crisped rice, wafers, or a cookie component?}
  \item{hard}{Is it a hard candy?}
  \item{bar}{Is it a candy bar?}
  \item{pluribus}{Is it one of many candies in a bag or box?}
  \item{sugarpercent}{The percentile of sugar it falls under within the data set.}
  \item{pricepercent}{The unit price percentile compared to the rest of the set.}
  \item{winpercent}{The overall win percentage according to 269,000 matchups.}
}
}
\source{
See \url{https://github.com/fivethirtyeight/data/tree/master/candy-power-ranking}
}
\usage{
candy_rankings
}
\description{
The raw data behind the story "The Ultimate Halloween Candy Power Ranking"
\url{https://fivethirtyeight.com/features/the-ultimate-halloween-candy-power-ranking/}.
}
\examples{
# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
library(stringr)
candy_rankings_tidy <- candy_rankings \%>\%
  pivot_longer(-c(competitorname, sugarpercent, pricepercent, winpercent), 
     names_to = "characteristics", values_to = "present") \%>\%
  mutate(present = as.logical(present)) \%>\%
  arrange(competitorname)
}
\keyword{datasets}
