% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_importance.R
\name{light_importance}
\alias{light_importance}
\alias{light_importance.default}
\alias{light_importance.flashlight}
\alias{light_importance.multiflashlight}
\title{Permutation Variable Importance}
\usage{
light_importance(x, ...)

\method{light_importance}{default}(x, ...)

\method{light_importance}{flashlight}(
  x,
  data = x$data,
  by = x$by,
  type = c("permutation", "shap"),
  v = NULL,
  n_max = Inf,
  seed = NULL,
  m_repetitions = 1L,
  metric = x$metrics[1L],
  lower_is_better = TRUE,
  use_linkinv = FALSE,
  ...
)

\method{light_importance}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class "flashlight" or "multiflashlight".}

\item{...}{Further arguments passed to \code{\link[=light_performance]{light_performance()}}.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{type}{Type of importance: "permutation" (currently the only option).}

\item{v}{Vector of variable names to assess importance for.
Defaults to all variables in \code{data} except "by" and "y".}

\item{n_max}{Maximum number of rows to consider.}

\item{seed}{An integer random seed used to select and shuffle rows.}

\item{m_repetitions}{Number of permutations. Defaults to 1.
A value above 1 provides more stable estimates of variable importance and
allows the calculation of standard errors measuring the uncertainty from permuting.}

\item{metric}{An optional named list of length one with a metric as element.
Defaults to the first metric in the flashlight. The metric needs to be a function
with at least four arguments: actual, predicted, case weights w and \code{...}.}

\item{lower_is_better}{Logical flag indicating if lower values in the metric
are better or not. If set to \code{FALSE}, the increase in metric is multiplied by -1.}

\item{use_linkinv}{Should retransformation function be applied? Default is \code{FALSE}.}
}
\value{
An object of class "light_importance" with the following elements:
\itemize{
\item \code{data} A tibble with results.
\item \code{by} Same as input \code{by}.
\item \code{type} Same as input \code{type}. For information only.
}
}
\description{
Importance of variable \code{v} is measured as drop in performance
by permuting the values of \code{v}, see Fisher et al. 2018 (reference below).
}
\details{
The minimum required elements in the (multi-)flashlight are "y", "predict_function",
"model", "data" and "metrics".
}
\section{Methods (by class)}{
\itemize{
\item \code{light_importance(default)}: Default method not implemented yet.

\item \code{light_importance(flashlight)}: Variable importance for a flashlight.

\item \code{light_importance(multiflashlight)}: Variable importance for a multiflashlight.

}}
\examples{
fit_part <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
fl_part <- flashlight(
  model = fit_part, label = "part", data = iris, y = "Sepal.Length"
)

# No effect of some variables (incl. standard errors)
plot(light_importance(fl_part, m_repetitions = 4), fill = "chartreuse4")

# Second model includes all variables
fit_full <- lm(Sepal.Length ~ ., data = iris)
fl_full <- flashlight(
  model = fit_full, label = "full", data = iris, y = "Sepal.Length"
)
fls <- multiflashlight(list(fl_part, fl_full))

plot(light_importance(fls), fill = "chartreuse4")
plot(light_importance(fls, by = "Species"))
}
\references{
Fisher A., Rudin C., Dominici F. (2018). All Models are Wrong but many are Useful:
Variable Importance for Black-Box, Proprietary, or Misspecified Prediction
Models, using Model Class Reliance. Arxiv.
}
\seealso{
\code{\link[=most_important]{most_important()}}, \code{\link[=plot.light_importance]{plot.light_importance()}}
}
