% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_cols}
\alias{remove_cols}
\alias{remove_cols.pivot_table}
\title{Remove columns from a pivot table}
\usage{
remove_cols(pt, c)

\method{remove_cols}{pivot_table}(pt, c)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{c}{A vector of numbers, column numbers.}
}
\value{
A \code{pivot_table} object.
}
\description{
Remove the columns whose numbers are indicated from the pivot table
represented by the object.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

All columns not belonging to the pivot table must be removed.
}
\examples{

pt <- pt_ex |> remove_cols(7)

pt <- pt_ex |> remove_cols(c(6,7))

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
