% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_operations.R
\name{fuzzy_d_squared}
\alias{fuzzy_d_squared}
\title{Compute the squared distance between two fuzzy numbers}
\usage{
fuzzy_d_squared(X, Y)
}
\arguments{
\item{X}{List. First triangular fuzzy number.}

\item{Y}{List. Second triangular fuzzy number.}
}
\value{
Numeric. The squared distance between \code{X} and \code{Y}.
}
\description{
Calculates the squared distance between two triangular fuzzy numbers using Diamond's metric.
}
\examples{
X <- list(l = 1, x = 2, r = 3)
Y <- list(l = 2, x = 3, r = 4)
fuzzy_d_squared(X, Y)
}
