% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_bmat.R
\name{sim_bmat}
\alias{sim_bmat}
\title{Randomly Generate FMP Parameters}
\usage{
sim_bmat(
  n_items,
  k,
  ncat = 2,
  xi_dist = list(runif, min = -1, max = 1),
  omega_dist = list(runif, min = -1, max = 1),
  alpha_dist = list(runif, min = -1, max = 0.5),
  tau_dist = list(runif, min = -3, max = 0)
)
}
\arguments{
\item{n_items}{Number of items for which to simulate item parameters.}

\item{k}{Either a scalar for the item complexity of all items or a
vector of length n_items if different items have different item complexities.}

\item{ncat}{Vector of length n_item giving the number of response
categories for each item. If of length 1, all items will have the same
number of response categories.}

\item{xi_dist}{List of information about the distribution from which to 
randomly sample xi parameters. The first element should be a function that
generates random deviates (e.g., runif or rnorm), and further elements 
should be named arguments to the function.}

\item{omega_dist}{List of information about the distribution from which to 
randomly sample omega parameters. The first element should be a function that
generates random deviates (e.g., runif or rnorm), and further elements 
should be named arguments to the function.}

\item{alpha_dist}{List of information about the distribution from which to 
randomly sample alpha parameters. The first element should be a function that
generates random deviates (e.g., runif or rnorm), and further elements 
should be named arguments to the function.
Ignored if all k = 0.}

\item{tau_dist}{List of information about the distribution from which to 
randomly sample tau parameters. The first element should be a function that
generates random deviates (e.g., runif or rnorm), and further elements 
should be named arguments to the function.
Ignored if all k = 0.}
}
\value{
\item{bmat}{Item parameters in the b parameterization (polynomial
coefficients).}
\item{greekmat}{Item parameters in the Greek-letter parameterization}
}
\description{
Generate monotonic polynomial coefficients for user-specified item
complexities and prior distributions.
}
\details{
Randomly generate FMP item parameters for a given k value.
}
\examples{
## generate FMP item parameters for 5 dichotomous items all with k = 2
set.seed(2342)
pars <- sim_bmat(n_items = 5, k = 2)
pars$bmat

## generate FMP item parameters for 5 items with varying k values and 
##  varying numbers of response categories
set.seed(2432)
pars <- sim_bmat(n_items = 5, k = c(1, 2, 0, 0, 2), ncat = c(2, 3, 4, 5, 2))
pars$bmat

}
