% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom-funs.R
\name{tidy.flexsurvreg}
\alias{tidy.flexsurvreg}
\title{Tidy a flexsurv model object}
\usage{
\method{tidy}{flexsurvreg}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  pars = "all",
  transform = "none",
  ...
)
}
\arguments{
\item{x}{Output from \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}}, representing a fitted survival model object.}

\item{conf.int}{Logical. Should confidence intervals be returned? Default is \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval if \code{conf.int = TRUE}. Default is \code{0.95}.}

\item{pars}{One of \code{"all"}, \code{"baseline"}, or \code{"coefs"} for all parameters, baseline distribution parameters, or covariate effects (i.e. regression betas), respectively. Default is \code{"all"}.}

\item{transform}{Character vector of transformations to apply to requested \code{pars}. Default is \code{"none"}, which returns \code{pars} as-is.

Users can specify one or both types of transformations:
\itemize{
\item \code{"baseline.real"} which transforms the baseline distribution parameters to the real number line used for estimation.
\item \code{"coefs.exp"} which exponentiates the covariate effects.
}

See \code{Details} for a more complete explanation.}

\item{...}{Not currently used.}
}
\value{
A \code{\link[tibble]{tibble}} containing the columns: \code{term}, \code{estimate}, \code{std.error}, \code{statistic}, \code{p.value}, \code{conf.low}, and \code{conf.high}, by default.

\code{statistic} and \code{p.value} are only provided for covariate effects (\code{NA} for baseline distribution parameters). These are computed as Wald-type test statistics with p-values from a standard normal distribution.
}
\description{
Tidy summarizes information about the components of the model into a tidy data frame.
}
\details{
\code{flexsurvreg} models estimate two types of coefficients, baseline distribution parameters, and covariate effects which act on the baseline distribution. By design, \code{flexsurvreg} returns distribution parameters on the same scale as is found in the relevant \code{d/p/q/r} functions. Covariate effects are returned on the log-scale, which represents either log-time ratios (accelerated failure time models) or log-hazard ratios for proportional hazard models. By default, \code{tidy()} will return baseline distribution parameters on their natural scale and covariate effects on the log-scale.

To transform the baseline distribution parameters to the real-value number line (the scale used for estimation), pass the character argument \code{"baseline.real"} to \code{transform}. To get time ratios or hazard ratios, pass \code{"coefs.exp"} to \code{transform}. These transformations may be done together by submitting both arguments as a character vector.
}
\examples{

fitg <- flexsurvreg(formula = Surv(futime, fustat) ~ age, data = ovarian, dist = "gengamma")
tidy(fitg)
tidy(fitg, pars = "coefs", transform = "coefs.exp")

}
