% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_flightst.R
\name{download_flights_data}
\alias{download_flights_data}
\title{Download and read ANAC flight data}
\usage{
download_flights_data(
  file_url = parent.frame()$file_url,
  showProgress = parent.frame()$showProgress,
  select = parent.frame()$select,
  cache = parent.frame()$cache
)
}
\arguments{
\item{file_url}{String. A url passed from \code{\link{get_flights_url}}.}

\item{showProgress}{Logical, passed from \code{\link{read_flights}}}

\item{select}{A vector of column names or numbers to keep, passed from \code{\link{read_flights}}}

\item{cache}{Logical, passed from \code{\link{read_flights}}}
}
\value{
A \verb{"data.table" "data.frame"} object
}
\description{
Download and read ANAC flight data
}
\examples{
\dontrun{ if (interactive()) {
# Generate url
file_url <- get_flights_url(type='basica', year=2000, month=11)

# download data
a <- download_flights_data(file_url=file_url, showProgress=TRUE, select=NULL)
}}
}
\keyword{internal}
