test_that("custom families are what they claim", {
  result <- occupancy_single(4)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 7)
  expect_equal(result$dpars, c("mu", "occ"))
  
  result <- occupancy_single_threaded(4)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 7)
  expect_equal(result$dpars, c("mu", "occ"))
  
  result <- occupancy_single_C()
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_true(result$loop)
  expect_length(result$vars, 1)
  expect_equal(result$dpars, c("mu", "occ"))
  
  result <- occupancy_augmented(4)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 10)
  expect_equal(result$dpars, c("mu", "occ", "Omega"))
  
  result <- occupancy_multi_colex(2, 3)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 10)
  expect_equal(result$dpars, c("mu", "occ", "colo", "ex"))
  
  result <- occupancy_multi_colex_eq(2, 3)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 10)
  expect_equal(result$dpars, c("mu", "colo", "ex"))
  
  result <- occupancy_multi_autologistic(2, 3)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 10)
  expect_equal(result$dpars, c("mu", "occ", "colo", "autologistic"))
  
  result <- occupancy_multi_autologistic_eq(2, 3)
  expect_is(result, "customfamily")
  expect_is(result, "brmsfamily")
  expect_is(result, "family")
  expect_false(result$loop)
  expect_length(result$vars, 10)
  expect_equal(result$dpars, c("mu", "colo", "autologistic"))
  
  
})
