% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{fmpc_price_history}
\alias{fmpc_price_history}
\title{Historical End of Day pricing data for one or more symbols}
\usage{
fmpc_price_history(
  symbols = "AAPL",
  startDate = Sys.Date() - 30,
  endDate = Sys.Date()
)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_by_market}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{startDate}{filter start date in yyyy-mm-dd format.}

\item{endDate}{filter end date in yyyy-mm-dd format.}
}
\value{
a data frame of price history
}
\description{
End of Day price history includes open, high, low, close, adjClose, volume,
vwap, and more. Symbol can include equity, mutual fund, index, currency, crypto,
or any other symbol that can be found in \code{\link{fmpc_symbols_by_market}}.
}
\section{Warning}{
 Each symbol is a separate API call. If the API token has
monthly limits, this should be considered before making a bulk request
}

\examples{


\dontrun{

# Default sets token to 'demo' which allows for AAPL only
fmpc_set_token()
fmpc_price_history('AAPL')

# For multiple symbols, set a valid API Token
# Crypto, equity, currency, and index can all be entered in the same request
fmpc_set_token('FMPAPIKEY')
fmpc_price_history(c('AAPL','MSFT','SPY','^SP500TR','JPYUSD','BTCUSD'))

}
}
