% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx_constraint.R
\name{getTeX}
\alias{getTeX}
\title{TeX Label (of Parameter Constraint(s)) of \linkS4class{fmx} Object}
\usage{
getTeX(dist, print_K = FALSE)
}
\arguments{
\item{dist}{\linkS4class{fmx} object}

\item{print_K}{\link[base]{logical} scalar, whether to print the number of components \eqn{K}.
Default \code{FALSE}.}
}
\value{
Function \code{\link[=getTeX]{getTeX()}} returns a \link[base]{character} scalar
(of TeX expression) of the constraint,
primarily intended for end-users in plots.
}
\description{
Create TeX label of (parameter constraint(s)) of \linkS4class{fmx} object
}
\examples{
(d0 = fmx('GH', A = c(1,4), g = c(.2,.1), h = c(.05,.1), w = c(1,1)))
getTeX(d0)

(d1 = fmx('GH', A = c(1,4), g = c(.2,0), h = c(0,.1), w = c(1,1)))
getTeX(d1)

(d2 = fmx('GH', A = c(1,4), g = c(.2,0), h = c(.15,.1), w = c(1,1)))
getTeX(d2)

}
\keyword{internal}
