% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airport_footprint.R
\name{airport_footprint}
\alias{airport_footprint}
\title{Calculate flight emissions based on airport code pairs}
\usage{
airport_footprint(
  departure,
  arrival,
  flightClass = "Unknown",
  output = "co2e",
  year = 2019
)
}
\arguments{
\item{departure}{a character vector naming one or more three-letter IATA (International Air Transport Association) airport codes for outbound destination}

\item{arrival}{a character vector naming one or more three-letter IATA (International Air Transport Association) airport codes for inbound destination}

\item{flightClass}{a character vector naming one or more flight class categories. Must be of the following "Unknown" "Economy", "Economy+", "Business" or "First". If no argument is included, "Unknown" is the default and represents the average passenger.}

\item{output}{a single character argument naming the emissions metric of the output. For metrics that include radiative forcing, one of
\itemize{
\item "co2e" (carbon dioxide equivalent with radiative forcing) - default
\item "co2" (carbon dioxide with radiative forcing)
\item "ch4" (methane with radiative forcing)
\item "n2o" (nitrous oxide with radiative forcing)
\item Metrics without radiative forcing: "co2e_norf", "co2_norf", "ch4_norf", or "n2o_norf".
}}

\item{year}{A numeric or string representing a year between 2019-2024, inclusive. Default is 2019.}
}
\value{
a numeric value expressed in kilograms of chosen metric
}
\description{
A function that calculates emissions per flight based on pairs of three-letter airport codes, flight classes, and emissions metrics. Emissions are returned in kilograms of the chosen metric.
}
\details{
Distances between airports are based on the Haversine great-circle distane formula, which assumes a spherical earth. They are calculated using the \code{airportr} package. The carbon footprint estimates are derived from the Department for Environment, Food & Rural Affairs (UK) Greenhouse Gas Conversion Factors for Business Travel (air). These factors vary by year, which can be acounted for by the \code{year} argument.
}
\examples{

# Calculations based on individual flights
airport_footprint("LAX", "LHR")
airport_footprint("LAX", "LHR", "First")
airport_footprint("LAX", "LHR", "First", "ch4")
airport_footprint("LAX", "LHR", output = "ch4")

# Calculations based on a data frame of flights
library(dplyr)
library(tibble)

travel_data <- tribble(~name, ~from, ~to, ~class,
                      "Mike", "LAX", "PUS", "Economy",
                      "Will", "LGA", "LHR", "Economy+",
                      "Elle", "TYS", "TPA", "Business")

travel_data |>
   rowwise() |>
   mutate(emissions = airport_footprint(from, to,
                                        flightClass = class,
                                        output="co2e"))

}
