% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeMSPEcpp}
\alias{computeMSPEcpp}
\title{Mean Squared Prediction Errors, for a single \eqn{h}}
\arguments{
\item{X}{the data}

\item{coef}{the array of coefficients.}

\item{h}{which lead time to compute the MSPE for}

\item{t}{a vector of times from which backward the forecasts are computed}

\item{type}{indicating what type of measure of accuracy is to be computed;
1: mspe, 2: msae}

\item{trimLo}{percentage of lower observations to be trimmed away}

\item{trimUp}{percentage of upper observations to be trimmed away}
}
\value{
Returns a \code{P x length(N)} matrix with the results.
}
\description{
This function computes the estimated mean squared prediction errors from a
given time series and prediction coefficients
}
\details{
The array of prediction coefficients \code{coef} is expected to be of
dimension \code{P x P x H x length(N) x length(t)} and in the format as
it is returned by the function \code{\link{predCoef}}. More precisely, for
\eqn{p=1,\ldots,P} and the \code{j.N}th element of \code{N} element of
\code{N} the coefficient of the
\code{h}-step ahead predictor for \eqn{X_{i+h}} which is computed from
the observations \eqn{X_i, \ldots, X_{i-p+1}} has to be available via
\code{coef[p, 1:p, h, j.N, t==i]}.

Note that \code{t} have to be the indices corresponding to the coefficients.

The resulting mean squared prediction error
\deqn{\frac{1}{|\mathcal{T}|} \sum_{t \in \mathcal{T}} (X_{t+h} - (X_t, \ldots, X_{t-p+1}) \hat v_{N[j.N],T}^{(p,h)}(t))^2}
is then stored in the resulting matrix at position \code{(p, j.N)}.
}
