#' forestinventory: A package for computing design-based estimates for multiphase forest inventories
#'
#' The package provides \strong{\emph{global}}- and \strong{\emph{smallarea estimators}} for
#' \strong{\emph{twophase}} and \strong{\emph{threephase}} forest inventories under simple and
#' cluster sampling, which have been developed by Daniel Mandallaz at
#' ETH Zurich. The implemented methods have been published and applied in various studies
#' (see \code{References}) and can be used for \strong{\emph{double- and triple sampling for stratification}},
#' \strong{\emph{double- and triple sampling for regression}} and \strong{\emph{double- and triple sampling for regression within strata}}.
#'
#'
#'@section Functions:
#'
#' The package provides three main functions to apply the various estimators for
#' \emph{twophase} and \emph{threephase} forest inventories:
#'
#' \itemize{
#'  \item \code{\link{twophase}}    Function to apply global- and various smallarea estimation techniques for twophase inventories
#'  \item \code{\link{threephase}}  Function to apply global- and various smallarea estimation techniques for threephase inventories
#'  \item \code{\link{onephase}}    Function to apply estimations for onephase inventories,  mainly for comparison
#'                                  with \code{two}-and \code{threephase}
#' }
#'
#'
#'@section Motivation:
#'
#' The Motivation of writing this package was to provide an extensive and consistent
#' collection of state-of-the-art \emph{design-based} estimation techniques for forest inventories.
#' It was especially designed to facilitate the application of the available estimators
#' in forest practice as well as in scientifically related studies. The work on this
#' package was also the trigger to complete the range of the already published estimators,
#' especially in the framework of three-phase smallarea estimators.
#'
#'
#'@section Selected references:
#'
#' Hill, A., Massey, A. F. (2021). \emph{The R Package forestinventory: Design-Based Global and Small
#' Area Estimations for Multiphase Forest Inventories.} Journal of Statistical Software, 97(4), 1-40.
#'
#' Massey, A. F. (2015). \emph{Multiphase estimation procedures for forest inventories under
#' the design-based Monte Carlo approach} (Doctoral dissertation, Diss., ETH Zurich, Nr. 23025).
#'
#' Mandallaz, D. (2013). \emph{Design-based properties of some small-area estimators in
#' forest inventory with two-phase sampling.} Canadian Journal of Forest Research, 43(5), 441-449.
#'
#' Mandallaz, D., Breschan, J., & Hill, A. (2013). \emph{New regression estimators in forest inventories
#' with two-phase sampling and partially exhaustive information: a design-based monte carlo approach
#' with applications to small-area estimation.} Canadian Journal of Forest Research, 43(11), 1023-1031.
#'
#' Mandallaz, D. (2013). \emph{A three-phase sampling extension of the generalized regression estimator
#' with partially exhaustive information.} Canadian Journal of Forest Research, 44(4), 383-388.
#'

#'
#'
#' @docType package
#' @name forestinventory
NULL
#> NULL
