% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_field.R
\name{update_field}
\alias{update_field}
\title{add or update field-specific metadata in a fr_tdr object}
\usage{
update_field(x, field, ...)
}
\arguments{
\item{x}{a \code{\link[=fr-package]{fr_tdr}} object}

\item{field}{character name of field in x to update}

\item{...}{\href{https://specs.frictionlessdata.io/table-schema/#field-descriptors}{table schema field descriptors} (e.g., \code{title}, \code{description})}
}
\value{
an \code{\link[=fr-package]{fr_tdr}} object containing the updated field
}
\description{
add or update field-specific metadata in a fr_tdr object
}
\examples{
my_mtcars <-
  mtcars |>
  as_fr_tdr(name = "mtcars") |>
  update_field("mpg", title = "Miles Per Gallon")

S7::prop(my_mtcars, "schema")
}
