% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tree.R
\name{build_tree}
\alias{build_tree}
\title{Build a 2D L-System Tree Using Turtle Graphics}
\usage{
build_tree(
  string = NULL,
  angle = 15,
  height = NULL,
  diameter = NULL,
  crown_diameter = NULL,
  h_reduction = (1 + sqrt(5))/2 - 1,
  d_reduction = (1 + sqrt(5))/2 - 1,
  randomness = FALSE,
  angle_cv = 0.1,
  length_cv = 0.1,
  leaf_size = NULL
)
}
\arguments{
\item{string}{A character vector containing the turtle graphics instructions, typically generated by the \code{iterate_lsystem} function.}

\item{angle}{A numeric value specifying the branching angle (in degrees). Default is 15.}

\item{height}{A numeric value specifying the total height of the plant, in meters.}

\item{diameter}{A numeric value specifying the base diameter of the plant, in centimeters.}

\item{crown_diameter}{A numeric value specifying the diameter of the plant crown, in meters.}

\item{h_reduction}{A numeric value representing the reduction factor applied to branch lengths. Default is the golden ratio (\eqn{(1+\sqrt{5})/2 - 1}).}

\item{d_reduction}{A numeric value representing the reduction factor applied to branch diameters. Default is the golden ratio (\eqn{(1+\sqrt{5})/2 - 1}).}

\item{randomness}{A logical value. If set to TRUE, randomness is introduced to the branch angles. Default is FALSE.}

\item{angle_cv}{A numeric value specifying the coefficient of variation for branch angles, applied when \code{randomness} is set to TRUE. Default is 0.1.}

\item{length_cv}{A numeric value specifying the coefficient of variation for branch lengths, applied when \code{randomness} is set to TRUE. Default is 0.1.}

\item{leaf_size}{An unquoted column name or a numeric value specifying the size of the leaves. Defaults to NULL, in which case the \code{d_reduction} value is used.}
}
\value{
A data frame containing the 2D tree profile data (component coordinates and types).
}
\description{
This function generates a 2D representation of a tree using L-system string instructions and turtle graphics.
The tree structure is determined by the L-system string, and various parameters control the shape, size, and randomness of the tree's growth.
}
