% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_discounting.R
\name{prior_fr}
\alias{prior_fr}
\title{prior_fr}
\usage{
prior_fr(post_fr, intro)
}
\arguments{
\item{post_fr}{The posterior probability of freedom (year = k-1)}

\item{intro}{The annual probability of introduction}
}
\value{
A vector. The prior probability of freedom (year = k)
}
\description{
Calculate the prior probability of freedom (year = k)
}
\details{
In order to calculate the posterior probability of freedom (year =
k) , the prior probability of freedom (year = k) is first
calculated from the posterior probability of freedom (year = k-1)
from the previous year and the annual probability that the disease
is introduced into the population.
}
\examples{
## Calculate the posterior probability of freedom after applying a
## sensitivity to a prior probability of freedom:
post_pf <- post_fr(0.5, 0.4)
## Then discount the probability of introduction (0.05) from the
## posterior probability of freedom to calculate the subsequent
## prior probability of freedom for the next time step:
prior_pf <- prior_fr(post_pf, 0.05)
}
