% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mri_synthstrip.R
\name{mri_synthstrip}
\alias{mri_synthstrip}
\alias{synthstrip}
\title{Use Freesurfers MRI SynthStrip}
\usage{
mri_synthstrip(
  file,
  outfile = NULL,
  retimg = TRUE,
  maskfile = NULL,
  opts = "",
  ...
)

synthstrip(
  file,
  outfile = NULL,
  retimg = TRUE,
  maskfile = NULL,
  opts = "",
  ...
)
}
\arguments{
\item{file}{(character) input filename}

\item{outfile}{(character) output filename}

\item{retimg}{(logical) return image of class nifti}

\item{maskfile}{(character) path for mask output}

\item{opts}{(character) additional options to \code{mri_mask}}

\item{...}{additional arguments passed to \code{\link{fs_cmd}}.}
}
\value{
Character or nifti depending on \code{retimg}
}
\description{
This function calls \code{mri_mask} to mask an image
}
\examples{
if (have_fs() && requireNamespace("oro.nifti", quietly = TRUE)) {
   img = oro.nifti::nifti(array(rnorm(5*5*5), dim = c(5,5,5)))  
   res = mri_synthstrip(img)
}
}
