% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_scalar.R
\name{is_scalar}
\alias{is_scalar}
\title{Check Whether an R Object is Scalar}
\usage{
is_scalar(x)
}
\arguments{
\item{x}{An \R object.}
}
\value{
A boolean.
}
\description{
\R is vector based. But I often come across vectors of length 1 or arrays and
matrices with a single element.
}
\examples{
x <- "C"
is_scalar(x)
x <- LETTERS[1:24]
!is_scalar(x)
is_scalar(x[3])
dim(x) <- c(6, 4)
!is_scalar(x)
is_scalar(x[1, 2])
dim(x) <- c(2, 3, 4)
!is_scalar(x)
is_scalar(x[1, 2, 3])
is_scalar(list(1))
}
\seealso{
Other logical helpers: 
\code{\link{get_run_r_tests}()},
\code{\link{is_batch}()},
\code{\link{is_cran}()},
\code{\link{is_false}()},
\code{\link{is_force}()},
\code{\link{is_installed}()},
\code{\link{is_not_false}()},
\code{\link{is_null_or_true}()},
\code{\link{is_of_length_zero}()},
\code{\link{is_r_cmd_check}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{is_scalar_convertible2numeric}()},
\code{\link{is_success}()},
\code{\link{is_true}()},
\code{\link{is_version_sufficient}()},
\code{\link{is_windows}()}
}
\concept{logical helpers}
