% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_convertible2numeric.R
\name{is_scalar_convertible2numeric}
\alias{is_scalar_convertible2numeric}
\title{Check Whether a Scalar is Convertible to Numeric}
\usage{
is_scalar_convertible2numeric(x)
}
\arguments{
\item{x}{A Scalar.}
}
\value{
A boolean.
}
\description{
Check Whether a Scalar is Convertible to Numeric
}
\examples{
x <- "3"
tinytest::expect_true(is_scalar_convertible2numeric(as.vector(x)))
tinytest::expect_true(is_scalar_convertible2numeric(as.list(x)))
tinytest::expect_true(is_scalar_convertible2numeric(as.array(x)))
tinytest::expect_true(is_scalar_convertible2numeric(as.matrix(x)))
x <- as.character(1:24)
tinytest::expect_error(is_scalar_convertible2numeric(x))
tinytest::expect_true(is_scalar_convertible2numeric(x[3]))
dim(x) <- c(6, 4)
tinytest::expect_error(is_scalar_convertible2numeric(x))
tinytest::expect_true(is_scalar_convertible2numeric(x[1, 2]))
dim(x) <- c(2, 3, 4)
tinytest::expect_error(is_scalar_convertible2numeric(x))
tinytest::expect_true(is_scalar_convertible2numeric(x[1, 2, 3]))

x <- LETTERS[1:24]
tinytest::expect_error(is_scalar_convertible2numeric(x))
tinytest::expect_false(is_scalar_convertible2numeric(x[3]))
dim(x) <- c(6, 4)
tinytest::expect_error(is_scalar_convertible2numeric(x))
tinytest::expect_false(is_scalar_convertible2numeric(x[1, 2]))
dim(x) <- c(2, 3, 4)
tinytest::expect_error(is_scalar_convertible2numeric(x))
tinytest::expect_false(is_scalar_convertible2numeric(x[1, 2, 3]))
}
\seealso{
Other logical helpers: 
\code{\link{get_run_r_tests}()},
\code{\link{is_batch}()},
\code{\link{is_cran}()},
\code{\link{is_false}()},
\code{\link{is_force}()},
\code{\link{is_installed}()},
\code{\link{is_not_false}()},
\code{\link{is_null_or_true}()},
\code{\link{is_of_length_zero}()},
\code{\link{is_r_cmd_check}()},
\code{\link{is_r_package_installed}()},
\code{\link{is_running_on_fvafrcu_machines}()},
\code{\link{is_running_on_gitlab_com}()},
\code{\link{is_scalar}()},
\code{\link{is_success}()},
\code{\link{is_true}()},
\code{\link{is_version_sufficient}()},
\code{\link{is_windows}()}
}
\concept{logical helpers}
