% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from.R
\name{from_here}
\alias{from_here}
\alias{from_wd}
\alias{from_rproj}
\alias{from_r_package}
\alias{from_remake}
\alias{from_drake}
\alias{from_targets}
\alias{from_pkgdown}
\alias{from_renv}
\alias{from_projectile}
\alias{from_quarto}
\alias{from_git}
\alias{from_svn}
\alias{from_vcs}
\alias{from_testthat}
\title{Create a File Path Relative to a Project Root}
\usage{
from_here(...)

from_wd(...)

from_rproj(...)

from_r_package(...)

from_remake(...)

from_drake(...)

from_targets(...)

from_pkgdown(...)

from_renv(...)

from_projectile(...)

from_quarto(...)

from_git(...)

from_svn(...)

from_vcs(...)

from_testthat(...)
}
\arguments{
\item{...}{Character components of the relative file path.}
}
\value{
A file path which allows further traversal with \code{$} autocompletion.
}
\description{
These functions generate file paths relative to the root of a specific type of project.
They use criteria from \code{rprojroot} to locate the root directory and construct paths
using \code{\link[=file.path]{file.path()}}.
}
\details{
Functions support two ways to specify paths: as function arguments
(e.g., \code{from_r_package("path/to/file")}) or using the \code{$} operator
(e.g., \code{from_r_package$path$to$file}), which supports autocompletion.

The following \verb{from_*} functions are available:
\itemize{
\item \code{from_here}: For paths relative to the \code{{here}} package's automatic project root.
\item \code{from_rproj}: For R project directories.
\item \code{from_r_package}: For R package directories.
\item \code{from_remake}: For remake project directories.
\item \code{from_drake}: For drake project directories.
\item \code{from_targets}: For targets project directories.
\item \code{from_pkgdown}: For pkgdown project directories.
\item \code{from_renv}: For renv project directories.
\item \code{from_projectile}: For Projectile project directories.
\item \code{from_quarto}: For Quarto project directories.
\item \code{from_git}: For Git repository root directories.
\item \code{from_svn}: For SVN repository root directories.
\item \code{from_vcs}: For generic version control root directories (Git or SVN).
\item \code{from_testthat}: For testthat directories.
}
}
\examples{
# Construct a path from the current working directory
from_wd()

\dontrun{
# Construct a path to a file in an R package
from_r_package("R", "my_file.R")

# Construct a path in a pkgdown project
from_pkgdown$docs$index.html

# Construct a path in a Git repository
from_git("src", "main.c")
}

}
\seealso{
\code{\link[rprojroot:find_root]{rprojroot::find_root()}}
}
