% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunburn.R
\name{sunburn}
\alias{sunburn}
\title{Evaluation of weather conditions for sunburn in apple fruit surface}
\usage{
sunburn(climdata, first_d, last_d)
}
\arguments{
\item{climdata}{a dataframe with daily maximum and minimum temperatures.
Must contain the columns Year, Month, Day, Tmax, Tmin.}

\item{first_d}{Numeric, it is the first date, indicated as day of the year
(DOY), in the assessment.}

\item{last_d}{a vector with the last(s) dates for the assessment (as DOY).
Examples could be harvest dates for several cultivars.}
}
\value{
data frame with the number of days within the assessed period(s).
Contains the columns Year, Harvest (values from last_d), SB_browning
and SB_necrosis.
}
\description{
This function estimates the number of days in which apple fruit
surface temperature (FST) exceeds the thresholds indicated by
Rackso and Schrader (2012) for two types of sunburn damages.
}
\details{
Sunburn necrosis (SN), the most severe type of sunburn, with a dark
brown or black necrotic spot on the exposed fruit surface is considered
to appear when FST reaches 52ºC. Sunburn browning (SB) is the most 
prevalent type of sunburn on attached sun-exposed apples (acclimated to
high light). The threshold temperature for SB is set in 46ºC, and 
corresponds to the most sensitive apple cultivars (like Cameo or 
Honeycrisp). 

FST is estimated from daily maximum air temperature using the expression
proposed by Schrader et al (2003).
}
\examples{

# Create one vector with start date (i.e. hand thinning) and a vector 
# with harvest dates to test sunburn risk for several cultivars using.
library(magrittr)
library(dplyr)
library(lubridate)
Thinning_d <- 135
Harvest_d <- c(225,245,260)
Sunburn_risk <- sunburn(Tudela_DW,Thinning_d, Harvest_d)

}
\references{
Rackso J and Schrader LE, 2012. Sunburn of apple fruit: Historical
background, recent advances and future perspectives. Critical Reviews
in Plant Sciences 31, 455-504.

Schrader L, Zhang J and Sun J, 2003. Environmental stresses that cause
sunburn of apple. Acta Horticulturae 618, 397-405.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
