% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_topological_relations.R
\name{spa_exact_inside}
\alias{spa_exact_inside}
\title{Check two spatial plateau objects for exact containment}
\usage{
spa_exact_inside(pgo1, pgo2)
}
\arguments{
\item{pgo1}{A \code{pgeometry} object that is either a plateau point, plateau line, or plateau region object.}

\item{pgo2}{A \code{pgeometry} object that is either a plateau point, plateau line, or plateau region object.}
}
\value{
A Boolean value that indicates if a \code{pgeometry} is completely and certainly inside \code{pgo2}.
}
\description{
\code{spa_exact_inside()} checks whether a \code{pgeometry} object is completely inside of another \code{pgeometry} object.
}
\details{
\code{spa_exact_inside()} is a Boolean function that checks \emph{fuzzy containment} in the spatial plateau context.
This Boolean function checks whether the components of \code{pgo1} are contained in the components of \code{pgo2}
by considering their membership degrees and geographic positions. That is, it follows the classical definition of fuzzy containment of the fuzzy set theory.

In other words, this function checks if the (standard) intersection of \code{pgo1} and \code{pgo2} is exactly equal to \code{pgo1}. The other of operands affects the result.
}
\examples{
pcp1 <- create_component("MULTIPOINT((2 2), (2 4), (2 0))", 0.5)
pcp2 <- create_component("MULTIPOINT((1 1), (3 1), (1 3), (3 3))", 0.9)
pcp3 <- create_component("POINT(2 2)", 0.2)
pcp4 <- create_component("MULTIPOINT((1 1), (3 3))", 0.7)

ppoint1 <- create_pgeometry(list(pcp1, pcp2), "PLATEAUPOINT")
ppoint2 <- create_pgeometry(list(pcp3, pcp4), "PLATEAUPOINT")

# is ppoint2 completely and certainly inside ppoint1?
spa_exact_inside(ppoint2, ppoint1)

# The order of operands after the result
# ppoint1 is not inside ppoint2 since it has different points
spa_exact_inside(ppoint1, ppoint2)
}
\references{
\href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
