% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmrcc.R
\name{FMRCC_PhaseII}
\alias{FMRCC_PhaseII}
\title{Phase II of the FMRCC}
\usage{
FMRCC_PhaseII(Y_test, X_test, phaseI)
}
\arguments{
\item{Y_test}{Test response variable. Must be same type as training data
(\code{mfd} for dense or \code{list} for sparse functional data).}

\item{X_test}{Test predictor variables. Must be same type as training data
(\code{mfd}, \code{matrix}, or \code{list}).}

\item{phaseI}{Output from \code{\link{FMRCC_PhaseI}} containing the trained
model and parameters.}
}
\value{
A list containing:
\item{ARL}{Average Run Length}
\item{phaseII}{Detailed Phase II results, a list with:
\itemize{
\item \code{df}: Data frame with columns:
\itemize{
\item \code{id}: Observation identifier
\item \code{loglikelihood}: Log-likelihood statistic for each observation
\item \code{status}: 'IC' (in-control) or 'OC' (out-of-control)
}
\item \code{ARL}: Average Run Length value
}
}
}
\description{
Performs Phase II of the FMRCC methodology.
}
\examples{
\donttest{
# Length of the functional grid
l <- 100
# Number of observations
n <- 300

# Generate training in-control data with three equally-sized clusters, maximum dissimilarity
data <- simulate_data_fmrcc(n_obs = n, delta_1 = 1, delta_2 = 0.5, len_grid = l, severity = 0)
X_train_mfd <- get_mfd_list(data_list = data['X'], n_basis = 20)
Y_train_mfd <- get_mfd_list(data_list = data['Y'], n_basis = 20)

# Generate tuning in-control data with three equally-sized clusters, maximum dissimilarity
data <- simulate_data_fmrcc(n_obs = n, delta_1 = 1, delta_2 = 0.5, len_grid = l, severity = 0)
X_tun_mfd <- get_mfd_list(data_list = data['X'], n_basis = 20)
Y_tun_mfd <- get_mfd_list(data_list = data['Y'], n_basis = 20)

# Example with dense functional data
phaseI_results <- FMRCC_PhaseI(
  Y_train = Y_train_mfd,
  X_train = X_train_mfd,
  Y_tun = Y_tun_mfd,
  X_tun = X_tun_mfd,
  FVEy = 0.95,
  FVEx = 0.90,
  alpha = 0.01,
  groups = 1:3,
  sigma_par = c('VVV', 'EEE')
)

# View BIC plot
phaseI_results$BIC_plt

# Generate out-of-control data with three equally-sized clusters, maximum dissimilarity
data <- simulate_data_fmrcc(n_obs = n, delta_1 = 1, delta_2 = 0.5, len_grid = l, severity = 2)
X_test_mfd <- get_mfd_list(data_list = data['X'], n_basis = 20)
Y_test_mfd <- get_mfd_list(data_list = data['Y'], n_basis = 20)

# Perform the monitoring of the Phase II data
phaseII_results <- FMRCC_PhaseII(
  Y_test = Y_test_mfd,
  X_test = X_test_mfd,
  phaseI = phaseI_results
)

# Check Average Run Length
phaseII_results$ARL

# View monitoring results
head(phaseII_results$phaseII$df)

# Identify out-of-control observations
oc_observations <- phaseII_results$phaseII$df[phaseII_results$phaseII$df$status == 'OC',]
oc_observations
}
}
\seealso{
\code{\link{FMRCC_PhaseI}}
}
