% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_K_functions}
\alias{plot_K_functions}
\title{Compare K Functions Between outcomes}
\usage{
plot_K_functions(data, inc.legend = TRUE, inc.noise = FALSE)
}
\arguments{
\item{data}{Data.frame with named columns r, K, unit, and outcome. The column
r indicates the radius of checked K function, K indicates the K function
value, unit specifies the unique K function, and outcome indicates the unit
outcome.}

\item{inc.legend}{(Optional) Boolean indicating if the legend should be given.
This will also include numbers to indicate if any K functions are missing.
The default is TRUE.}

\item{inc.noise}{(Optional) Boolean indicating if a gray, dashed line should
be included to show what spatially random noise would be like. The default
is FALSE.}
}
\value{
ggplot2 object showing the K function with a superimposed average.
}
\description{
This function plots K functions from different outcomes for comparison.
Group means are included as bold lines. Additionally a reference line for
a spatially random process can be included.
}
\examples{
# Example 1
tmp <- getKFunction(TNBC_pheno[TNBC_pheno$Class == 0, -1],
  agents = c("Tumor", "Tumor"),
  unit = "Person",
  rCheckVals = seq(0, 50, 1)
)
tmp1 <- getKFunction(TNBC_pheno[TNBC_pheno$Class == 1, -1],
  agents = c("Tumor", "Tumor"),
  unit = "Person",
  rCheckVals = seq(0, 50, 1)
)
tmp_1 <- tidyr::pivot_longer(data = tmp, cols = K1:K18)
tmp1_1 <- tidyr::pivot_longer(data = tmp1, cols = K1:K15)

data_plot <- rbind(
  data.frame(
    "r" = tmp_1$r,
    "K" = tmp_1$value,
    "unit" = tmp_1$name,
    "outcome" = "0"
  ),
  data.frame(
    "r" = tmp1_1$r,
    "K" = tmp1_1$value,
    "unit" = paste0(tmp1_1$name, "_1"),
    "outcome" = "1"
  )
)

pk1 <- plot_K_functions(data_plot)

# Example 2
tmp <- getKFunction(TNBC_pheno[TNBC_pheno$Class == 0, -1],
  agents = c("Tumor", "B"), unit = "Person",
  rCheckVals = seq(0, 50, 1)
)
tmp1 <- getKFunction(TNBC_pheno[TNBC_pheno$Class == 1, -1],
  agents = c("Tumor", "B"), unit = "Person",
  rCheckVals = seq(0, 50, 1)
)

tmp_1 <- tidyr::pivot_longer(data = tmp, cols = K1:K18)
tmp1_1 <- tidyr::pivot_longer(data = tmp1, cols = K1:K15)

data_plot <- rbind(
  data.frame(
    "r" = tmp_1$r,
    "K" = tmp_1$value,
    "unit" = tmp_1$name,
    "outcome" = "0"
  ),
  data.frame(
    "r" = tmp1_1$r,
    "K" = tmp1_1$value,
    "unit" = paste0(tmp1_1$name, "_1"),
    "outcome" = "1"
  )
)

pk2 <- plot_K_functions(data_plot)
}
