% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarity_dimensions.R
\name{distinctiveness_dimensions}
\alias{distinctiveness_dimensions}
\title{Distinctiveness across combinations of traits}
\usage{
distinctiveness_dimensions(pres_matrix, traits_table, ...)
}
\arguments{
\item{pres_matrix}{a site-species matrix, with species in rows and sites
in columns, containing presence-absence, relative abundances or
abundances values}

\item{traits_table}{a data.frame of traits with species in row and traits in
columns, \strong{row names} should be \strong{species names},}

\item{...}{additional arguments supplied to \code{\link[=compute_dist_matrix]{compute_dist_matrix()}}}
}
\value{
a list of site-species matrix with functional distinctiveness values
per species per site, with elements \strong{Di_X} for distinctiveness
computed on trait \strong{X} and \strong{Di_all} for distinctiveness computed
on all traits.
}
\description{
From a trait data.frame and a site-species matrix compute Distinctiveness
(average pairwise functional distance) for each species in each community
on each provided trait and on all traits taken altogether.
}
\examples{
data("aravo", package = "ade4")

# Site-species matrix
mat = as.matrix(aravo$spe)
rel_mat = make_relative(mat)

# Example of trait table
tra = aravo$traits[, c("Height", "SLA", "N_mass")]

di_dim = distinctiveness_dimensions(rel_mat, tra)

}
\seealso{
\code{\link[=uniqueness_dimensions]{uniqueness_dimensions()}}, \code{\link[=distinctiveness]{distinctiveness()}},
\code{\link[=distinctiveness_stack]{distinctiveness_stack()}} and \code{\link[=compute_dist_matrix]{compute_dist_matrix()}} for additional
arguments
}
