% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgnc2pfam.R
\name{hgnc2pfam}
\alias{hgnc2pfam}
\title{Map from Hugo symbol to Pfam domains}
\usage{
hgnc2pfam(hgnc.symbol, guess = TRUE, uniprot.id = NA, output.format = "json")
}
\arguments{
\item{hgnc.symbol}{primary Hugo symbol}

\item{guess}{if the given Hugo symbol links to multiple UniProt IDs,
choose the longest one (\code{guess == TRUE});
otherwise \code{NA} (\code{guess == FALSE}).  Default \code{TRUE}.}

\item{uniprot.id}{UniProt ID, in case that gene symbol maps to multiple UniProt entries.}

\item{output.format}{output format: JSON or list}
}
\value{
A list or a JSON with attributes:
    \emph{symbol}, \emph{uniprot}, \emph{length}, and a list of \emph{Pfam} entries, including
    \emph{hmm.acc}, \emph{hmm.name}, \emph{start}, \emph{end}, and \emph{type}.
}
\description{
Mapping from Hugo symbol to Pfam-A domain composition.
If the given Hugo symbol has multiple UniProt ID mappings,
and \code{guess == TRUE},
the longest UniProt protein is selected. Return is either a list of a JSON.
}
\examples{
# general usage
hgnc2pfam("TP53")
hgnc2pfam("TP53", output.format = "json")
hgnc2pfam("TP53", output.format = "list")
hgnc2pfam("TP53", output.format = "json", uniprot.id = "P04637") # OK

# for gene mapping to multiple UniProt enties
hgnc2pfam("GNAS", guess = TRUE)
hgnc2pfam("GNAS", guess = FALSE)
hgnc2pfam("GNAS", output.format = "list")
hgnc2pfam("GNAS", output.format = "list", uniprot.id = "P84996")
\dontrun{
hgnc2pfam("GNAS", output.format = "list", uniprot.id = "P84997") # , returns FALSE
}

hgnc2pfam("PRAMEF9", output.format = "list") # no Pfam mappings

}
