% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_varcomps.R
\name{anova_table}
\alias{anova_table}
\title{ANOVA Table Calculation}
\usage{
anova_table(data, part, operator, meas)
}
\arguments{
\item{data}{An R dataframe or tibble.}

\item{part}{A column in data specifying the unique ID of the part being measured}

\item{operator}{A column in data specifying the operator for the recorded measurement}

\item{meas}{A column in data where the measurement value is recorded.}
}
\value{
An anova table of meas ~ operator x part
}
\description{
ANOVA Table Calculation
}
\examples{
data = data.frame(
SN = c(
'SerialNumber_01',
'SerialNumber_01',
'SerialNumber_02',
'SerialNumber_02',
'SerialNumber_01',
'SerialNumber_01',
'SerialNumber_02',
'SerialNumber_02'),

Operator = c(
'Operator_01',
'Operator_01',
'Operator_01',
'Operator_01',
'Operator_02',
'Operator_02',
'Operator_02',
'Operator_02'),

Measure = c(
0.0172,
0.0177,
0.0155,
0.0159,
0.0174,
0.0181,
0.0152,
0.0176))

anova_table(data, part = 'SN', operator = 'Operator', meas = 'Measure')
}
