% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbar_r_varcomps.R
\name{xbar_repeat}
\alias{xbar_repeat}
\title{Average and Range Method Repeatability Calculation}
\usage{
xbar_repeat(data, part, operator, meas)
}
\arguments{
\item{data}{An R dataframe or tibble containing the required identifier and measurement columns.}

\item{part}{Column name (unquoted) specifying the unique ID of the part being measured. The column should be a
character or factor vector.}

\item{operator}{Column name (unquoted) specifying the operator for the recorded measurement. The column should be a
character or factor vector.}

\item{meas}{Column name (unquoted) where the measurement value is recorded. The column must be numeric and contain no
missing or infinite values.}
}
\value{
A number. The measure of repeatability for the given data.
}
\description{
Average and Range Method Repeatability Calculation
}
\examples{
data <- data.frame(
  SN = rep(c("SerialNumber_01","SerialNumber_02"), each = 4),
  Operator = rep(c("Operator_01","Operator_02"), each = 2, times = 2),
  Measure = c(0.0172,0.0177,0.0155,0.0159,0.0174,0.0181,0.0152,0.0176)
)
xbar_repeat(data, part = 'SN', operator = 'Operator', meas = 'Measure')
}
