% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gratia_appraise.R
\name{appraise.galamm}
\alias{appraise.galamm}
\alias{appraise}
\title{Gratia style model diagnostic plots}
\usage{
\method{appraise}{galamm}(model, ...)
}
\arguments{
\item{model}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{...}{Other arguments passed on to \code{\link[gratia:appraise]{gratia::appraise()}}.}
}
\value{
A ggplot object.
}
\description{
This function uses \code{gratia::appraise} to make model diagnostic plots.
See \code{\link[gratia:appraise]{gratia::appraise()}} for details. When \code{model} is not of class
\code{galamm}, it is forwarded to \code{gratia::appraise()}.
}
\examples{
dat <- subset(cognition, domain == 1 & item == "11")
dat$y <- dat$y[, 1]
mod <- galamm(y ~ s(x) + (1 | id), data = dat)
appraise(mod)

}
\seealso{
Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{derivatives.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{model.frame.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
