% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAMLSS_BSSN.R
\name{BSSN}
\alias{BSSN}
\alias{dBSSN}
\alias{pBSSN}
\alias{qBSSN}
\alias{rBSSN}
\title{Bimodal Skew Symmetric Normal Distribution}
\usage{
BSSN(mu.link = "identity", sigma.link = "log", nu.link = "identity",
  tau.link = "log")

dBSSN(x, mu = 0, sigma = 1, nu = 1, tau = 0.5, log = FALSE)

pBSSN(q, mu = 0, sigma = 1, nu = 1, tau = 0.5, lower.tail = TRUE,
  log.p = FALSE, log = T)

qBSSN(p, mu = 0, sigma = 1, nu = 1, tau = 0.5, lower.tail = TRUE,
  log.p = FALSE)

rBSSN(n, mu = 0, sigma = 1, nu = 1, tau = 0.5)
}
\arguments{
\item{mu.link}{Defines the mu.link, with identity link as the default for the mu parameter}

\item{sigma.link}{Defines the sigma.link, with log link as the deafult for the sigma parameter}

\item{nu.link}{Defines the nu.link, with identity link as the default for the nu parameter}

\item{tau.link}{Defines the tau.link, with log link as the default for the tau parameter}

\item{x, q}{Vector of quantiles}

\item{mu}{Vector of location parameter values}

\item{sigma}{Vector of scale parameter values}

\item{nu}{Vector of nu parameter values}

\item{tau}{Vector of bimodality parameter values}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x]}

\item{p}{Vector of probabilities}

\item{n}{number of observations; if length(n) > 1, the length is taken to be the number required}
}
\description{
These functions define the Bimodal Skew Symmetric Normal Distribution. This is a four parameter distribution and can be used to fit a GAMLSS model.The functions dBSSN, pBSSN, qBSSN and rBSSN define the probability distribution function, the cumulative distribution function,  the inverse cumulative distribution functions and  the random generation for the Bimodal Skew Symmetric Normal Distribution; respectively.
}
\details{
The probability density function of the BSSN distribution is given by \deqn{f_Y(y|\mu, \sigma, \nu, \tau)= c[\tau + (y-\nu)^(2)]e^{-\sigma(y-\mu)^(2)}} for \eqn{-\infty < y < \infty}, where \eqn{c = 2\sigma^(3/2) / \gamma \sqrt\pi},  \eqn{\gamma= 1 + 2 \sigma \theta},  \eqn{\theta = \tau + \delta^{2}},  \eqn{\delta= \nu - \mu}. \eqn{-\infty <\mu <\infty} and  \eqn{-\infty < \nu < \infty} are location parameters and \eqn{\sigma >0} and \eqn{\tau \geq 0 } denote the scale and bimodality parameters respectively.
}
\examples{
op<-par(mfrow=c(3,3))
curve(dBSSN(x,  mu=1, sigma=0.1, nu=1, tau=1),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=1, sigma=0.1, nu=1, tau=5),-12, 12,ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=1, sigma=0.1, nu=1, tau=10),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=1, sigma=0.1, nu=1, tau=20),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=1, sigma=0.1, nu=0, tau=4),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=-1, sigma=0.1, nu=0, tau=3),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=1, sigma=0.1, nu=2, tau=0),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=-1, sigma=0.1, nu=-2, tau=0),-12, 12, ylab="f(x)", main="BSSN")
curve(dBSSN(x,  mu=-1, sigma=0.1, nu=-3, tau=0.8),-12, 12, ylab="f(x)", main="BSSN")
par(op)
}
\references{
Hassan, M. Y. and  El-Bassiouni M. Y. (2015). Bimodal skew-symmetric normal distribution,\emph{Communications in Statistics-Theory and Methods}, \bold{45}, part 5, pp 1527--1541.

Hossain, A.Rigby, R. A. Stasinopoulos D. M. and Enea, M. A flexible approach for modelling proportion response variable:LGD, \emph{31st International workshop for Statistical Modelling Society},\bold{1}, pp 127--132.

Rigby, R. A. and  Stasinopoulos D. M. (2005). Generalized additive models for location, scale and shape,(with discussion), \emph{Appl. Statist.}, \bold{54}, part 3, pp 507-554.
}
