% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode_prediction.R
\name{ode_prediction}
\alias{ode_prediction}
\title{Optimizer extension}
\usage{
ode_prediction(pars_full, time, N)
}
\arguments{
\item{pars_full}{Initial Population Size}

\item{time}{A vector of times. Must be repeated once per species.}

\item{N}{Number of species. Can be either a number, or a vector the same length as time.}
}
\value{
a stacked vector with predicted abundances for all species
}
\description{
Takes in paramter values in the form returned by the gause_wrapper function,
and calculates expected abundances for all n species, returned as a single vector.
This function is potentially useful in combination with other optimizer software,
e.g. as might be used for hypothesis testing.
}
\examples{
#load competition data
data("gause_1934_science_f02_03")

#subset out data from species grown in mixture
mixturedat<-gause_1934_science_f02_03[gause_1934_science_f02_03$Treatment=="Mixture",]

#extract time and species data
time<-mixturedat$Day
species<-data.frame(mixturedat$Volume_Species1, mixturedat$Volume_Species2)
colnames(species)<-c("P_caudatum", "P_aurelia")

\donttest{
#run wrapper
gause_out<-gause_wrapper(time=time, species=species)

# number of species
N<-ncol(gause_out$rawdata)-1
# parameters
pars_full<-c(gause_out$parameter_intervals$mu)
# data.frame for optimization
fittigdata<-data.frame(y=unlist(gause_out$rawdata[,-1]),
                       time=gause_out$rawdata$time,
                       N=N)

yest<-ode_prediction(pars_full, time=fittigdata$time, N=fittigdata$N)
plot(fittigdata$y, yest, xlab="observation", ylab="prediction")
abline(a=0, b=1, lty=2)

#example of how to apply function, using nls()
mod<-nls(y~ode_prediction(pars_full, time, N),
           start = list(pars_full=pars_full),
           data=fittigdata)
summary(mod)
}
}
\concept{Gause}
\concept{competition}
\concept{optimization}
