% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussfacts.R
\name{gaussfact}
\alias{gaussfact}
\alias{print.gaussfact}
\title{Display a Random Fact about Carl Friedrich Gauss}
\usage{
gaussfact(ind)

\method{print}{gaussfact}(x, width = NULL, ...)
}
\arguments{
\item{ind}{Optional index of a quote; if missing a random value is sampled}

\item{x}{Default object for \code{print} method}

\item{width}{Optional column width parameter}

\item{...}{Other optional arguments}
}
\value{
A character vector containing one randomly selected line
 from the included file. It is of class \code{gaussfact} for
which an S3 print method will be invoked.
}
\description{
Function to display a randomly chosen fact about Carl Friedrich Gauss
}
\details{
This function displays a randomly chosen line from the included
data set of of random \sQuote{facts} about Carl Friedrich Gauss.
It is based on corpus curated by Mike Cavers via the
\url{http://gaussfacts.com} site, and kindly made available.
}
\examples{
  set.seed(123)
  gaussfact()
}
\author{
Dirk Eddelbuettel
}
\seealso{
\code{\link[fortunes:fortunes]{fortune}},
  \code{\link[rmsfact:rmsfact]{rmsfact}}
}

