% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbifdb-package.R
\docType{package}
\name{gbifdb-package}
\alias{gbifdb}
\alias{gbifdb-package}
\title{gbifdb: High Performance Interface to 'GBIF'}
\description{
A high performance interface to the Global Biodiversity Information Facility, 'GBIF'. In contrast to 'rgbif', which can access small subsets of 'GBIF' data through web-based queries to a central server, 'gbifdb' provides enhanced performance for R users performing large-scale analyses on servers and cloud computing providers, providing full support for arbitrary 'SQL' or 'dplyr' operations on the complete 'GBIF' data tables (now over 1 billion records, and over a terabyte in size). 'gbifdb' accesses a copy of the 'GBIF' data in 'parquet' format, which is already readily available in commercial computing clouds such as the Amazon Open Data portal and the Microsoft Planetary Computer, or can be accessed directly without downloading, or downloaded to any server with suitable bandwidth and storage space. The high-performance techniques for local and remote access are described in \url{https://duckdb.org/why_duckdb} and \url{https://arrow.apache.org/docs/r/articles/fs.html} respectively.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/gbifdb/}
  \item \url{https://github.com/ropensci/gbifdb}
  \item Report bugs at \url{https://github.com/ropensci/gbifdb}
}

}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (\href{https://orcid.org/0000-0002-1642-628X}{ORCID})

}
\keyword{internal}
