% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle2d.R
\name{angle2d}
\alias{angle2d}
\title{Determine angle}
\usage{
angle2d(coords1, coords2, radians = FALSE, invert = TRUE)
}
\arguments{
\item{coords1}{An \eqn{N \times 2} matrix of spatial
coordinates.}

\item{coords2}{An \eqn{N \times 2} matrix of spatial
coordinates.}

\item{radians}{A logical value indicating whether the
angles returned should be in degrees or radians.  The
default is \code{FALSE}, indicating that the returned
angles are in degrees.}

\item{invert}{A logical value indicating whether the axes
of the coordinates should be inverted (i.e., the x- and
y-axis are switched). The default is \code{TRUE} to
mimic results from other geostatistical R packages like
\code{gstat}, \code{geoR}, and other software like
\code{GSLIB} and \code{GeoEAS}. Set to \code{FALSE} to
use the typical x- and y-axes.}
}
\value{
Returns a vector of angles.
}
\description{
\code{angle2d} determines the angle between pairs of
coordinates in degrees or radians.  The coordinates are
assumed to be in two-dimensional space.
}
\details{
Note that the angle is between the actual pairs of
points, not the angle between the vectors extending from
the origin to the points.  e.g., the angle between (0, 1)
and (1, 1) is 90 degrees, not 45. The sign of the
direction not accounted for, e.g., a -135 degree angle is
rotated by 180 degrees to become a 45 degree angle.  All
angles returned are in the interval [0, 180].
}
\examples{
coords1 = matrix(0, nrow = 8, ncol = 2)
coords2 = cbind(c(2, 2, 0, -2, -2, -2, 0, 2), c(0, 2, 2, 2, 0, -2, -2, -2))
angle2d(coords1, coords2)
angle2d(coords1, coords2, radians = TRUE)
}
\author{
Joshua French
}
