% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compPortfo.R
\name{compPortfo}
\alias{compPortfo}
\title{Compares two vectors (portfolios) using
momentVote, DecileVote and exactSdMtx functions.}
\usage{
compPortfo(xa, xb)
}
\arguments{
\item{xa}{{Data on returns for portfolio A in the form of a T by 1 vector}}

\item{xb}{{Data on returns for portfolio B in the form of a T by 1 vector}}
}
\value{
Returns three numbers which represent signs based differences in
ranks (rank=1 for most desirable) measured by [rank(xa)-rank(xb)] using
momentVote, decileVote, and  exactSdMtx which are weighted
averages of four moments, nine deciles and exact measures of stochastic
dominance (from ECDFs of four orders, SD1 to SD4) respectively.
}
\description{
Given two vectors of portfolio returns this function summarizes their ranks
based on moments, deciles and exact measures of stochastic dominance.
as explained in Vinod (2021). This algorithm has model selection applications.
}
\note{
There are model-selection applications where two models A and B are
compared and one wants to choose the model smaller absolute value of
residuals. This function when applied for model-selection will have
he inputs xa and xb as absolute residuals. We can compare the entire
probability distributions of absolute residuals by moments, deciles
or SD1 to SD4. Of course, care must be taken to choose xa or
xb depending on which model has smaller absolute residuals. This choice
is the exact opposite of portfolio choice application where
larger return is more desirable.  \code{silentPair2()}
and \code{siPair2Blk} call this
function for model selection application.
}
\examples{

set.seed(30)
xa=sample(20:30)#generally lower returns
xb=sample(32:40)# higher returns in xb
gp = compPortfo(xa, xb)#all Av(sdi) positive means xb dominates
##output (1,1,1) means xb dominates xa. xb are larger by consruction

}
\references{
Vinod, H. D.", "Hands-On Intermediate Econometrics 
Using R"  (2008) World Scientific Publishers: Hackensack, NJ. (Chapter 4)
\url{https://www.worldscientific.com/worldscibooks/10.1142/12831}

Vinod, Hrishikesh D., R Package GeneralCorr 
Functions for Portfolio Choice 
(November 11, 2021). Available at SSRN: 
https://ssrn.com/abstract=3961683
}
\seealso{
\code{\link{exactSdMtx}}

\code{\link{momentVote}}

\code{\link{decileVote}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{financial portfolio choice}
\concept{stochastic dominance}
